#!/bin/bash
# Must be executed from within the source "root".
NAME=bemacupsdrv
VERSION=1.2.0.0
TEMPDIR=/tmp/${NAME}-${VERSION}
FILELIST="install.sh uninstall.sh *.ppd.gz rastertobema usbbema 69-bema.rules setup.txt"
# Compile a new version before packaging
#make clean
#make
# Create temp dir, removing previously directories with same name
rm -rf ${TEMPDIR}
mkdir ${TEMPDIR}
# Copy files
for file in ${FILELIST}; do
  cp -f  -v  ${file} ${TEMPDIR}
done
# Rename files
#rename "-binaries" "" ${TEMPDIR}/*-binaries
# Create tar file
tar -C /tmp -cvzf ./release/${NAME}-${VERSION}-bin.tar.gz ${NAME}-${VERSION}/
# Erase temp dir
rm -rf $TEMPDIR
exit 0
